//
//  OPCategory.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-02-19.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import "OPDatabaseObject.h"
#import "OPTemplate.h"
#import "OPGenericCategory.h"

@interface OPCategory : OPDatabaseObject <OPGenericCategory, OPDisplayOrderable, NSSecureCoding>

// OPGenericCategory
@property (nonatomic, copy) NSString * uuid;
@property (nonatomic, copy) NSString * singularName;
@property (nonatomic, copy) NSString * pluralName;
@property (nonatomic, copy) NSString * actionName;
@property (readonly, getter = isSystemCategory) BOOL systemCategory;
@property (readonly, getter = isPremiumCategory) BOOL premiumCategory;
@property (nonatomic, copy) NSString * listIconName;
@property (nonatomic, copy) NSString * detailIconName;
@property (nonatomic) NSUInteger numberOfItems;

@property (nonatomic) BOOL hasCustomIcon;
@property (nonatomic, strong) OPImage * customIcon;

@property (nonatomic, readonly, getter = isHidden) BOOL hidden;

// OPDisplayOrderable
@property (nonatomic) NSUInteger displayOrder;

@end


